% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{get_segs}
\alias{get_segs}
\title{Divide a bullet signature/profile into basis segments of desired length}
\usage{
get_segs(x, len = 50)
}
\arguments{
\item{x}{a numeric vector, vector of the bullet signature/profile}

\item{len}{integer: the desired length of a basis segment}
}
\value{
list with basis segments and their corresponding indices in the profile
}
\description{
\code{get_segs} divides a bullet signature/profile (a numeric vector) into consecutive,
non-overlapping, basis segments of the same desired length. If the profile
starts or ends with a sequence of \code{NA} (missing values), the \code{NA}s will be trimmed.
If the very last segment does not have the desired length, it will be dropped.
}
\examples{
data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
x <- land2_3$sig

segments <- get_segs(x, len = 50)
}
