% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_simulate.R
\name{simulate.coalmodel}
\alias{simulate.coalmodel}
\title{Simulate Data According to a Demographic Model}
\usage{
\method{simulate}{coalmodel}(object, nsim = 1, seed, ..., pars = numeric(0), cores = 1)
}
\arguments{
\item{object}{The coalescent model to be simulated}

\item{nsim}{currently unused}

\item{seed}{A random seed that is set before simulation.}

\item{...}{currently unused}

\item{pars}{Values for parameters specified with \code{\link{par_named}} or
\code{\link{par_range}}. Should be a named numeric vector.}

\item{cores}{The number of cores that the independent repetitions from
\code{nsim} will be distributed on.
Must be \code{1} on Windows, and should also be \code{1} when using R
in a graphical environment (e.g. Rstudio).}
}
\value{
A list of summary statistics.
}
\description{
This function simulates a model created with \code{\link{coal_model}}.
The model can be extended with features, \code{\link{parameter}s} and
loci. Read the 'coala-introduction' vignette for detailed instructions
on creating and simulating such models.
}
\examples{
model <- coal_model(10, 3) +
  feat_mutation(5) +
  sumstat_sfs() +
  sumstat_tajimas_d()
simulate(model, nsim = 2)

model <- coal_model(c(5,10), 20) +
  feat_pop_merge(par_range('tau', 0.01, 5), 2, 1) +
  feat_mutation(par_range('theta', 1, 10)) +
  sumstat_jsfs()
simulate(model, pars=c(tau = 1, theta = 5))
}
