% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-from-posterior.R
\name{draw_from_posterior}
\alias{draw_from_posterior}
\title{Draw random numbers from posterior distribution}
\usage{
draw_from_posterior(survey, nsim = 10000, seed = as.numeric(now()),
  prior = NULL, correction = NULL)
}
\arguments{
\item{survey}{survey object as returned by \code{as_survey} or \code{getSurveys}}

\item{nsim}{number of simulations}

\item{seed}{sets seed}

\item{prior}{optional prior information. Defaults to 1/2 (Jeffrey's prior).}

\item{correction}{A positive number. If not \code{NULL}, each sample from the
Dirichlet distribution will be additionally "corrected" by a random number
from U(-1*correction, 1*correction). This can be used to introduce extra
variation which might be useful due to rounding errors from reported survey
results (or add an additional source of variation in general).}
}
\value{
\code{data.frame} containing random draws from Dirichlet distribution
which can be interpreted as election results.
}
\description{
Draw random numbers from posterior distribution
}
\seealso{
\code{\link{as_survey}}
}
\keyword{draw,}
\keyword{simulate}
