% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/common_plots.R
\name{ggplot_dclst}
\alias{ggplot_dclst}
\title{Plotting data collections using ggplot}
\usage{
ggplot_dclst(dc_lst, ylim = NULL, titleArr = names(dc_lst),
  legendMode = "none", dfplot = ggplot_df)
}
\arguments{
\item{dc_lst}{A list of data collections i.e. a list of lists of data.frames (see examples)}

\item{ylim}{(optional) y-axis limits as [1,2] numeric, passed on to dfplot() as 'ylim'}

\item{titleArr}{(optional)  Plot column titles as [1, length(dc_lst)] string array}

\item{legendMode}{(optional) Where to put legend, allowed values c('none','first','all')}

\item{dfplot}{(optional) Function used to plot a data.frame (one panel in final plot)}
}
\value{
Produces a plot to the active graphics device
}
\description{
Plotting data collections using ggplot
}
\examples{
\dontrun{
dc <- create_syn_data_toy()
ccr <- cocoreg(dc$data)
ggplot_dclst(list(d1 = dc$data, d2 = ccr$data, dn = dc$data))
}
}

