% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoreg.R
\name{cocoreg}
\alias{cocoreg}
\title{The Common Components by Regression (CoCoReg) algorithm}
\usage{
cocoreg(data, cyclic = FALSE, mapping_function = mapping_lm,
  sample_paths = FALSE, center_data = T, scale_data = F)
}
\arguments{
\item{data}{[1,K] list of data.frames.}

\item{cyclic}{boolean, Operation mode: cyclic or non-cyclic}

\item{mapping_function}{function, The function to use in mappings.
See mapping_lm() for an example.}

\item{sample_paths}{boolean, If FALSE all paths are computed. If TRUE a
subset of paths is taken: one (random) path for each starting point.
Currently implemented only for cyclic=F.}

\item{center_data}{boolean, Should the data be centered?}

\item{scale_data}{boolean, Should the data be scaled?}
}
\value{
A list with elements:
\item{$data:}{[1,K] list of data.frames containing the joint information,
               organised identically to the input data.}
\item{$mappings:}{[1,K*K-K] list of functions, mappings between datasets}
\item{$paths:}{[(K-1)(K-2)!, K] list of lists, paths for each data set}
\item{$cyclic:}{input cyclic as is}
\item{$sample_paths:}{boolean, TRUE if paths have been sampled, FALSE otherwise.}
\item{$dataid:}{string, Dataset identifier string}
\item{$method:}{string, Analysis method identifier string}
\item{$wall_time_taken:}{[1,1] double, Time taken to run the analysis in seconds}
}
\description{
An algorithm that extracts common variation between datasets using regression.
}
\examples{
dc <- create_syn_data_toy()
ccr <- cocoreg(dc$data)

ggplot_dflst(dc$data, ncol=1)
ggplot_dflst(ccr$data, ncol=1)

\dontrun{
ggplot_dclst(list(orig = dc$data, ccr = ccr$data)) 
ggplot_dclst(list(orig = dc$data, shared = ccr$data), legendMode = 'none')
ggplot_dclst(list(orig = dc$data, ccr = ccr$data), legendMode = 'all')
}

}
