% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda_coxnet.R
\name{plot_survcurves}
\alias{plot_survcurves}
\title{plot_survcurves}
\usage{
plot_survcurves(risk.score, time, status, strata.quantile = 0.5)
}
\arguments{
\item{risk.score}{microbial risk score values resulting from the coda_coxnet model}

\item{time}{time to event or follow up time for right censored data. Must be a vector (type:numeric) specifying time to event for each sample for right censored data (what about interval data?).}

\item{status}{event occurrence. Vector (type: numeric or logical) specifying 0 or FALSE for no event occurrence, and 1 or TRUE for event occurrence.}

\item{strata.quantile}{cut-off quantile (values 0, 1) for sample stratification based on signature value. Default is set to 0.5 quantile of the signature.}
}
\value{
return an object of class ggsurvplot which is list containing the following:
plot: the survival plot (ggplot object).
table: the number of subjects at risk table per time (ggplot object).
data.survplot: data used to plot the survival curves (data.frame).
data.survtable: data used to plot the tables under the main survival curves (data.frame).
}
\description{
Plots survival curves stratifying samples based on their signature value.
Signature value for stratification can be set by the user.
}
\examples{

set.seed(12345)

data(data_survival, package = "coda4microbiome")
time <- Event_time
status <- Event
crohn_cox <- coda_coxnet(x = x,
                         time = Event_time,
                         status = Event,
                         covar = NULL,
                         lambda = "lambda.1se", nvar = NULL,
                         alpha = 0.9, nfolds = 10, showPlots = TRUE, coef_threshold = 0)
plot_survcurves(risk.score = crohn_cox$risk.score,
                 time,
                 status,
                 strata.quantile = 0.5)


#-------------------------------------------------------------------------------
}
\author{
M. Calle, M. Pujolassos, T. Susin
}
