% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_classcodes.R
\name{set_classcodes}
\alias{set_classcodes}
\title{Set classcodes object}
\usage{
set_classcodes(
  cc,
  classified = NULL,
  regex = NULL,
  start = TRUE,
  stop = FALSE,
  tech_names = NULL
)
}
\arguments{
\item{cc}{\code{\link{classcodes}} object (or name of a default object from
\code{\link[=all_classcodes]{all_classcodes()}}).}

\item{classified}{object that classcodes could be inherited from}

\item{regex}{name of column with regular expressions to use for
classification.
\code{NULL} (default) uses \code{attr(obj, "regexpr")[1]}.}

\item{start, stop}{should codes start/end with the specified regular
expressions? If \code{TRUE}, column "regex" is prefixed/suffixed
by \verb{^/$}.}

\item{tech_names}{should technical column names be used? If \code{FALSE},
colnames are taken directly from group names of \code{cc}, if \code{TRUE},
these are changed to more technical names avoiding special characters and
are prefixed by the name of the classification scheme.
\code{NULL} (by default) preserves previous names if \code{cc} is inherited from
\code{classified} (fall backs to \code{FALSE} if not already set).}
}
\value{
\code{\link{classcodes}} object.
}
\description{
Prepare a \code{classcodes}object by specifying the regular expressions
to use for classification.
}
\examples{
# Prepare a classcodes object for the Charlson comorbidity classification
# based on the default regular expressions
set_classcodes(charlson)   # by object
set_classcodes("charlson") # by name

# Same as above but based on regular expressions for ICD-8 (see `?charlson`)
set_classcodes(charlson, regex = "icd8_brusselaers")

# Only recognize codes if no other characters are found after the relevant codes
# Hence if the code vector stops with the code
set_classcodes(charlson, stop = TRUE)

# Accept code vectors with strings which do not necessarily start with the code.
# This is useful if the code might appear in the middle of a longer character
# string or if a common prefix is used for all codes.
set_classcodes(charlson, start = FALSE)

# Use technical names to clearly describe the origin of each group.
# Note that the `cc` argument must be specified by a character string
# since this name is used as part of the column names
x <- set_classcodes("charlson", tech_names = TRUE)
x$group
}
\seealso{
Other classcodes: 
\code{\link{all_classcodes}()},
\code{\link{as.data.frame.classified}()},
\code{\link{classcodes}},
\code{\link{codebook}()},
\code{\link{print.classcodes}()},
\code{\link{print.classified}()},
\code{\link{summary.classcodes}()},
\code{\link{visualize.classcodes}()}
}
\concept{classcodes}
