% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch_impl.R
\name{LinColorSpace}
\alias{LinColorSpace}
\title{Creates a linear color space between two colors}
\usage{
LinColorSpace(color1, color2, n.out)
}
\arguments{
\item{color1}{the first color (must be of the class \link[colorspace:color-class]{colorspace::color})}

\item{color2}{the second color (must be of the class \link[colorspace:color-class]{colorspace::color})}

\item{n.out}{number of output colors}
}
\value{
a palette
}
\description{
Creates a linear color space between two colors
}
\examples{
library(colorspace)
library(colorpatch)
pal <- LinColorSpace(sRGB(0,1,0), sRGB(0,0.1,0), 32)
pal <- append(pal, sRGB(0,0,0))
pal <- append(pal, LinColorSpace(sRGB(0.1,0,0), sRGB(1,0,0), 32))
PlotUniformity(pal)
print(pal)
}
