% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onLoad.R
\name{c4a_options}
\alias{c4a_options}
\title{Set cols4all options}
\usage{
c4a_options(...)
}
\arguments{
\item{...}{Use character values to retrieve options. To set options, either use named arguments (where the names refer to the options), a list that consists of those options.}
}
\value{
A list of options
}
\description{
Get or set global options for c4a. Works similar as the base function \code{options}
}
\details{
\tabular{ll}{
   \strong{Option} \tab \strong{Description} \cr
   defaults \tab Default palettes per type \cr
   CBF_th \tab Parameters that label a palette as color blind friendly \cr
   CBU_th \tab Parameters that label a palette as color blind unfriendly \cr
   CrangeFair \tab Maximum chroma range for which a palette is considered harmonic \cr
   CrangeUnfair \tab Minimum chroma range for which a palette is considered disharmonic \cr
   LrangeFair \tab Maximum luminance range for which a palette is considered harmonic \cr
   LrangeUnfair \tab Minimum luminance range for which a palette is considered disharmonic \cr
   Cintense \tab Chroma of colors that are considered intense \cr
   Cpastel \tab Chroma of colors that are considered 'pastel' \cr
   HwidthDivRainbow \tab A diverging palette is labeled as 'rainbow hue' if HwidthL or HwidthR are at least \code{HwidthDivRainbow} \cr
   HwidthDivSingle \tab A diverging palette is labeled as 'single hue' if HwidthL and HwidthR are at most \code{HwidthDivSingle} \cr
   HwidthSeqRainbow \tab A sequential palette is labeled as 'rainbow hue' if Hwidth is at least \code{HwidthSeqRainbow} \cr
   HwidthSeqSingle \tab A sequential palette is labeled as 'single hue' if Hwidth is at most \code{HwidthSeqSingle} \cr
}
}
