% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wecoma.R
\name{get_wecoma}
\alias{get_wecoma}
\title{Create a weighted co-occurrence matrix (wecoma)}
\usage{
get_wecoma(x, w, neighbourhood = 4, fun = "mean",
  na_action = "replace")
}
\arguments{
\item{x}{A RasterLayer with categories}

\item{w}{A RasterLayer with weights}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{fun}{"mean", "geometric_mean", or "focal". The default is "mean".}

\item{na_action}{"replace", "omit", or "keep". The default is "replace".}
}
\value{
A weighted co-occurrence matrix
}
\description{
Create a weighted co-occurrence matrix (wecoma)
}
\examples{
library(comat)
library(raster)
data(x, package = "comat")
data(w, package = "comat")
plot(x)
plot(w)

wom = get_wecoma(x, w)
wom

}
