% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{InMemoryData}
\alias{InMemoryData}
\title{In memory data class to store data in RAM}
\format{\code{\link{S4}} object.}
\description{
\code{InMemoryData} creates an data object which can be used as source or
target object within the base-learner factories of \code{compboost}. The
convention to initialize target data is to call the constructor without
any arguments.
}
\section{Usage}{

\preformatted{
InMemoryData$new()
InMemoryData$new(data.mat, data.identifier)
}
}

\section{Arguments}{

\describe{
\item{\code{data.mat} [\code{matrix}]}{
  Matrix containing the source data. This source data is later transformed
  to obtain the design matrix a base-learner uses for training.
}
\item{\code{data.identifier} [\code{character(1)}]}{
  The name for the data specified in \code{data.mat}. Note that it is
  important to have the same data names for train and evaluation data.
}
}
}

\section{Details}{

  The \code{data.mat} needs to suits the base-learner. For instance, the
  spline base-learner does just take a one column matrix since there are
  just one dimensional splines till now. Additionally, using the polynomial
  base-learner the \code{data.mat} is used to control if a intercept should
  be fitted or not by adding a column containing just ones. It is also
  possible to add other columns to estimate multiple features
  simultaneously. Anyway, this is not recommended in terms of unbiased
  features selection.

  The \code{data.mat} and \code{data.identifier} of a target data object
  is set automatically by passing the source and target object to the
  desired factory. \code{getData()} can then be used to access the
  transformed data of the target object.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classdata_1_1_in_memory_data.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{getData()}}{method extract the \code{data.mat} from the data object.}
\item{\code{getIdentifier()}}{method to extract the used name from the data object.}
}
}

\examples{
# Sample data:
data.mat = cbind(1:10)

# Create new data object:
data.obj = InMemoryData$new(data.mat, "my.data.name")

# Get data and identifier:
data.obj$getData()
data.obj$getIdentifier()

}
