% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LossAbsolute}
\alias{LossAbsolute}
\title{Absolute loss for regression tasks.}
\format{\code{\link{S4}} object.}
\description{
This loss can be used for regression with \eqn{y \in \mathrm{R}}.
}
\details{
\strong{Loss Function:}
\deqn{
  L(y, f(x)) = | y - f(x)|
}
\strong{Gradient:}
\deqn{
  \frac{\delta}{\delta f(x)}\ L(y, f(x)) = \mathrm{sign}( f(x) - y)
}
\strong{Initialization:}
\deqn{
  \hat{f}^{[0]}(x) = \mathrm{arg~min}_{c\in R}\ \frac{1}{n}\sum\limits_{i=1}^n
  L(y^{(i)}, c) = \mathrm{median}(y)
}
}
\section{Usage}{

\preformatted{
LossAbsolute$new()
LossAbsolute$new(offset)
}
}

\section{Arguments}{

\describe{
\item{\code{offset} [\code{numeric(1)}]}{
  Numerical value which can be used to set a custom offset. If so, this
  value is returned instead of the loss optimal initialization.
}
}
}

\section{Details}{


  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classloss_1_1_absolute_loss.html}.
}

\examples{

# Create new loss object:
absolute.loss = LossAbsolute$new()
absolute.loss

}
