% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massey.R
\name{massey}
\alias{massey}
\alias{rate_massey}
\alias{rank_massey}
\title{Massey method}
\usage{
rate_massey(cr_data)

rank_massey(cr_data, keep_rating = FALSE, ties = c("average", "first",
  "last", "random", "max", "min"), round_digits = 7)
}
\arguments{
\item{cr_data}{Competition results in format ready for
\link[comperes:as_longcr]{as_longcr()}.}

\item{keep_rating}{Whether to keep rating column in ranking output.}

\item{ties}{Value for \code{ties} in \code{\link[=round_rank]{round_rank()}}.}

\item{round_digits}{Value for \code{round_digits} in \code{\link[=round_rank]{round_rank()}}.}
}
\value{
\code{rate_massey()} returns a \link[tibble:tibble]{tibble} with columns
\code{player} (player identifier) and \code{rating_massey} (Massey
\link[=rating-ranking]{rating}). The sum of all ratings should be equal to 0.
\strong{Bigger value indicates better player performance}.

\code{rank_massey()} returns a \code{tibble} with columns \code{player}, \code{rating_massey} (if
\code{keep_rating = TRUE}) and \code{ranking_massey} (Massey \link[=rating-ranking]{ranking}
computed with \code{\link[=round_rank]{round_rank()}}).
}
\description{
Functions to compute \link[=rating-ranking]{rating} and \link[=rating-ranking]{ranking}
using Massey method.
}
\details{
This rating method was initially designed for games between two
players. There will be an error if in \code{cr_data} there is a game not between
two players. Convert input competition results manually or with
\link[comperes:to_pairgames]{to_pairgames()} from \code{comperes} package.

It is assumed that score is numeric and higher values are better for the
player.

Computation is done based only on the games between players of interest (see
Players). \strong{Note} that all those players should be present in \code{cr_data}
because otherwise there will be an error during solving linear system
described below. Message is given if there are players absent in \code{cr_data}.

The outline of Massey rating method is as follows:
\enumerate{
\item Compute Massey matrix: diagonal elements are equal to number of games
played by certain player, off-diagonal are equal to minus number of common
games played. This matrix will be the matrix of system of linear equations
(SLE).
\item Compute right-hand side of SLE as cumulative score differences of players,
i.e. sum of all scores \emph{for} the player minus sum of all scores \emph{against} the
player.
\item Make adjustment for solvability of SLE. Modify the last row of Massey
matrix so that all its cells are equal to 1. Also change the last cell in
right-hand side to 0. This adjustment ensures that sum of all outcome ratings
will be 0.
\item Solve the SLE. The solution is the Massey rating.
}
}
\section{Players}{


\code{comperank} offers a possibility to handle certain set of players. It is done
by having \code{player} column (in \link[comperes:as_longcr]{longcr} format) as factor
with levels specifying all players of interest. In case of factor the result
is returned only for players from its levels. Otherwise - for all present
players.
}

\examples{
rate_massey(ncaa2005)

rank_massey(ncaa2005)

rank_massey(ncaa2005, keep_rating = TRUE)

}
\references{
Kenneth Massey (1997) \emph{Statistical models applied to the
rating of sports teams}. Bachelor’s thesis, Bluefield College.
}
