% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlm.R
\name{summary.rzlm}
\alias{summary.rzlm}
\title{Summary Method for Robust Linear Models}
\usage{
\method{summary}{rzlm}(object, method = c("XtX", "XtWX"), correlation = FALSE, ...)
}
\arguments{
\item{object}{An object inheriting from the class 'rzlm'. That is, a fitted model that was generated by \link{rlm}.}

\item{method}{Character string indicating if the IWLS weights should be used when calculating matrix cross-products. "XtX" does not include weights, "XtWX" does.}

\item{correlation}{Logical. Should the correlations be computed and printed?}

\item{...}{Other arguments, passed to or from other methods.}
}
\value{
Returns a list containing the following elements. If the list is printed by the function (\code{print.summary.rlm} or invoked as a method by \code{summary}), a null value is returned instead.
\item{\code{correlation}}{A numeric matrix. The computed correlation coefficient matrix for the coefficients in the model.}
\item{\code{pseudocorrelation}}{A complex matrix. The computed pseudo-correlation coefficient matrix for the coefficients in the model.}
\item{\code{cov.unscaled}}{The unscaled covariance matrix; i.e, a numeric matrix such that multiplying it by an estimate of the error variance produces an estimated covariance matrix for the coefficients.}
\item{\code{pcov.unscaled}}{The unscaled pseudo-covariance matrix; i.e, a complex matrix such that multiplying it by an estimate of the error pseudo-variance produces an estimated pseudo-covariance matrix for the coefficients.}
\item{\code{sigma}}{Numeric. The scale estimate returned by \code{rlm}, which was used to scale the residuals before passing them to the \code{psi} weight function.}
\item{\code{stddev}}{Numeric. A scale estimate used for the standard errors. Calculated from the working residuals, the \code{psi} weight function, and the derivative of the influence function (\code{psi.method(deriv = 1)}).}
\item{\code{pstddev}}{Complex. A scale estimate used for the 'pseudo' standard errors. Calculated from the working residuals, the \code{psi} weight function, and the derivative of the influence function (\code{psi.method(deriv = 1)}). See details above.}
\item{\code{df}}{The number of degrees of freedom for the model and for residuals.}
\item{\code{coefficients}}{A 4 column matrix that contains the model coefficients, their standard errors, their pseudo standard errors (see details above), and their t statistics.}
\item{\code{terms}}{The terms object used in fitting this model.}
}
\description{
Summary method for objects of class "rzlm", capable of processing complex variable fits.
If the residuals in the passed object are numeric, this function just calls \code{\link[MASS:summary.rlm]{MASS::summary.rlm()}}.
}
\details{
This is a method for the generic \code{summary()} function. It is based on the function of the same name from MASS, but has been modified to accept complex numbers.
In addition to the standard error of the coefficients, it calculates a "pseudo standard error" or "relational standard error" as the square root of the "pseudo-variance".
This is a complex number that quantifies the covariance between the real and imaginary parts. It can also be thought of as the amount and direction of anisotropy in the
(presumed complex normal) probability distribution in the complex plane. The argument of this number gives the direction of the semi-major axis.
}
\examples{
set.seed(4242)
n <- 8
slope <- complex(real = 4.23, imaginary = 2.323)
intercept <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
x <- complex(real = rnorm(n), imaginary = rnorm(n))
y <- slope * x + intercept + e
robfit <- rlm(x = x, y = y, weights = rep(1,n), interc = TRUE)
summary(robfit)
}
\references{
W. N. Venables and B. D. Ripley, Modern Applied Statistics with S, 4th ed (Springer, New York, 2002).
P. J. Huber and E. Ronchetti, Robust Statistics, 2nd ed (Wiley, Hoboken, N.J, 2009).
}
