% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{cs_parse_date}
\alias{cs_parse_date}
\title{Separate Date Occur}
\usage{
cs_parse_date(.data, var, dateVar, timeVar, tz = NULL, keepDateTime = TRUE)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{A column containing month, day, year, and time separated by \code{/}}

\item{dateVar}{Name of new column to contain date data}

\item{timeVar}{Name of new column to contain time data}

\item{tz}{String name of timezone, defaults to system's timezone}

\item{keepDateTime}{A logical scalar. Keep an intermediate dateTime variable if \code{TRUE}.}
}
\value{
A copy of the object with two columns appended. One is the time data and the other is the date data.
}
\description{
Creates two columns. One contains month, day, and year and the other contains hour, and minute.
}
\examples{
# load example data
testData <- january2018

# parse date occured
testData <- cs_parse_date(testData, var = date_occur, dateVar = dateOcc, timeVar = timeOcc)

}
