% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.condor_log.R
\name{summary.condor_log}
\alias{summary.condor_log}
\title{Summary Condor Log}
\usage{
\method{summary}{condor_log}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{condor_log}}.}

\item{\dots}{passed to \code{round}.}
}
\value{
Data frame with the following columns:
\item{job.id}{job id.}
\item{status}{text indicating whether job status is submitted, executing, or
      finished.}
\item{submit.time}{date and time when job was submitted.}
\item{runtime}{total duration of a job.}
\item{disk}{disk space used by job (MB).}
\item{memory}{memory used by job (MB).}
}
\description{
Produce a summary of a Condor log file.
}
\examples{
\dontrun{

# Examine log files on submitter machine
session <- ssh_connect("servername")

condor_dir()
condor_log()
summary(condor_log())

#' # Alternatively, examine log files on local drive
condor_dir(local.dir="c:/myruns")
condor_log(local.dir="c:/myruns/01_this_model")
summary(condor_log(local.dir="c:/myruns/01_this_model"))
}

}
\seealso{
\code{\link{condor_log}} shows Condor log file.

\code{\link{condor-package}} gives an overview of the package.
}
