% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionplots.R
\name{conditionPlot}
\alias{conditionPlot}
\title{Plots a conditionPlot.}
\usage{
conditionPlot(
  CVdata,
  var,
  varVal,
  pointColor = "steelblue",
  sim = NULL,
  resetpar = TRUE,
  plotrows = NULL
)
}
\arguments{
\item{CVdata}{the dataset used for the fit}

\item{var}{one more condition vars. Draws a parallel coordinate plot for more than two.}

\item{varVal}{the current setting of the conditionvars, shown in magenta.}

\item{pointColor}{a color, vector of colors,or the name of variable to be used for coloring}

\item{sim}{If non-NULL should be a vector of similarity weights.}

\item{resetpar}{For use withing shiny app.}

\item{plotrows}{If non-NULL should be a vector of case indices}
}
\description{
Plots a conditionPlot, showing one, two or many predictors. The predictor setting in \code{varVal} is drawn in magenta.
}
\examples{
conditionPlot(mtcars, c("wt","hp"), c("wt"=3, "hp"=200), pointColor="am")

conditionPlot(mtcars, c("wt","hp"), mtcars[1,], pointColor="am")

#Calculate similarity using wt, hp observations from first case
sim <- similarityweight(mtcars[1, c("wt","hp")], mtcars[, c("wt","hp")], threshold=1)

# Marks points with black border with positive sim values. These are points within 1 (threshold) sd
#of pink cross.
conditionPlot(mtcars, c("wt","hp"), mtcars[1,], pointColor="am", sim=sim)

sim <- similarityweight(mtcars[1, ], mtcars, threshold=2)
conditionPlot(mtcars, names(mtcars), mtcars[1,], sim=sim)

}
