% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_scale.R
\name{ci_mad}
\alias{ci_mad}
\title{CI for the MAD}
\usage{
ci_mad(
  x,
  probs = c(0.025, 0.975),
  constant = 1.4826,
  type = "bootstrap",
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}

\item{constant}{Scaling factor applied. The default (1.4826) ensures that the MAD
equals the standard deviation for a theoretical normal distribution.}

\item{type}{Type of CI. Currently not used as the only type is "bootstrap".}

\item{boot_type}{Type of bootstrap CI c("bca", "perc", "norm", "basic").}

\item{R}{The number of bootstrap resamples.}

\item{seed}{An integer random seed.}

\item{...}{Further arguments passed to \code{boot::boot()}.}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates bootstrap CIs (default: "bca") for the population median
absolute deviation (MAD), see \code{stats::mad()} for more information on this measure of scale.
}
\examples{
x <- rnorm(100)
ci_mad(x, R = 999)  # Use larger R
}
