% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_rsquared.R
\name{ci_f_ncp}
\alias{ci_f_ncp}
\title{CI for the Non-Centrality Parameter of the F Distribution}
\usage{
ci_f_ncp(x, df1 = NULL, df2 = NULL, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{The result of \code{\link[stats:lm]{stats::lm()}} or the F test statistic.}

\item{df1}{The numerator df. Only used if \code{x} is a test statistic.}

\item{df2}{The denominator df. Only used if \code{x} is a test statistic.}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
Based on the inversion principle, parametric CIs for the non-centrality parameter
(NCP) Delta of the F distribution are calculated.
To keep the input interface simple, we do not provide bootstrap CIs here.
}
\details{
A positive lower \eqn{(1 - \alpha) \cdot 100\%}-confidence limit for the NCP goes
hand-in-hand with a significant F test at level \eqn{\alpha}.
According to \code{\link[stats:Fdist]{stats::pf()}}, the results might be unreliable for very large F values.
}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
ci_f_ncp(fit)
ci_f_ncp(fit, probs = c(0.05, 1))
}
\references{
Smithson, M. (2003). Confidence intervals. Series: Quantitative Applications in the
Social Sciences. New York, NY: Sage Publications.
}
\seealso{
\code{\link[=ci_rsquared]{ci_rsquared()}}
}
