% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.split.R
\name{plot_multidim_split}
\alias{plot_multidim_split}
\title{Plot Confidence Regions obtained with Split Conformal}
\usage{
plot_multidim_split(split, same.scale = FALSE)
}
\arguments{
\item{split}{The output of a split multivariate conformal
prediction function.}

\item{same.scale}{Should I force the same scale for all the y-axis ? Default
is FALSE.}
}
\value{
g_list A list of ggplots
}
\description{
Plot Confidence Regions obtained with Split Conformal
}
\details{
It exploits the package \code{\link{ggplot2}} and \code{\link{gridExtra}}
to better visualize the results. It outputs n0=length(x0) plots.
}
\examples{
n=50
p=4
q=2


mu=rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
beta<-sapply(1:q, function(k) c(mvtnorm::rmvnorm(1,mu)))
y = x\%*\%beta + t(mvtnorm::rmvnorm(q,1:n))
x0=x[ceiling(0.9*n):n,]
y0=y[ceiling(0.9*n):n,]

n0<-nrow(y0)
q<-ncol(y)

fun=mean_multi()
fun=lm_multi()
fun=elastic.funs()


############################## SPLIT CONFORMAL


final.point = conformal.multidim.split(x,y,x0, fun$train.fun, fun$predict.fun,
                             alpha=0.1,
                                split=NULL, seed=FALSE, randomized=FALSE,seed_rand=FALSE,
                                verbose=FALSE, rho=0.5,score ="l2",s_type="st-dev")

ppp2<-plot_multidim_split(final.point)
}
