% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{diagnose}
\alias{diagnose}
\title{Function to loop over the lengthen() and balance() functions.}
\usage{
diagnose(input, diagnostic, approach = "none", scope, censoring, id,
  times.exposure, times.covariate, exposure, temporal.covariate,
  static.covariate = NULL, history = NULL, weight.exposure = NULL,
  censor = NULL, weight.censor = NULL, strata = NULL,
  recency = NULL, average.over = NULL, periods = NULL,
  list.distance = NULL, sort.order = "alphabetical", loop = "no",
  ignore.missing.metric = "no", metric = "SMD", sd.ref = "no")
}
\arguments{
\item{input}{dataframe in wide format (e.g., indexed by person)}

\item{diagnostic}{diagnostic of interest e.g. 1, 2, or 3}

\item{approach}{adjustment method e.g. "none" or "weight" or "stratify"}

\item{scope}{report the entire trellis e.g. "all", the diagonal e.g. "recent", or a summary e.g. "average"}

\item{censoring}{use censoring indicators/weights e.g. "yes" or "no"}

\item{id}{unique observation identifier e.g. "id"}

\item{times.exposure}{vector of exposure measurement times e.g. c(0,1,2)}

\item{times.covariate}{vector of covariate measurement times e.g. c(0,1,2)}

\item{exposure}{root name of exposure e.g. "a"}

\item{temporal.covariate}{a vector of root names for covariates whose values change over time e.g. c("l","m","n","o","p")}

\item{static.covariate}{a vector of root names for covariates whose values do not change (covariates listed here should not appear in the temporal.covariate argument)}

\item{history}{the root name for history measurements e.g. "h"}

\item{weight.exposure}{the root name for exposure weights e.g. "wa"}

\item{censor}{the root name for censoring indicators e.g. "s"}

\item{weight.censor}{the root name for censoring weights e.g. "ws"}

\item{strata}{the root name for propensity-score strata e.g. "e"}

\item{recency}{an integer for the relative distance between exposures and covariate measurements to focus on (e.g. 0 would represent the same timing). The default is 0 for Diagnostics 1 and 3, and 1 for Diagnostic 2}

\item{average.over}{summary level for average metrics e.g. standardize over "values" or "history" or "time" or "distance"}

\item{periods}{a list of contiguous segments of relative distance to pool over e.g. list(0,1:4,5:10) would yield summaries over three segments}

\item{list.distance}{a vector of distances to retain after averaging over time e.g. c(0,2)}

\item{sort.order}{vector of root names for all covariates listed in the order in whcihc they should appear in the table (and also plot) e.g. c("n","m","o","l","p"). To display covariates in alphabetical order (the default), leave blank or type "alphabetical"}

\item{loop}{"yes" to iteratively apply balance() and lengthen() or "no" to process all covariates and measurement times at once.}

\item{ignore.missing.metric}{"yes" or "no" depending on whether the user wishes to estimate averages over person-time when there are missing values of the mean difference or standardized mean difference. Missing values for the standardized mean difference can occur when, for example, there is no covariate variation within levels of exposure-history and measurement times. If this argument is set to "no" and there are missing values, the average will also be missing. If set to "yes" an average will be produced that ignores missing values.}

\item{metric}{the metric for which the user wishes to ignore missing values as specified in the 'ignore.missing.metric' argument.}

\item{sd.ref}{"yes" or "no" depending on whether the user wishes to use the standard deviation of the reference group when calculating the SMD.}
}
\value{
A covariate balance table. See the \code{balance()} function for details.
}
\description{
Function to loop over the lengthen() and balance() functions.
}
\details{
When using the balance() , diagnose(), or  apply.scope() functions, specifying average.over="average" and average.over="time" will return balance metrics for each "distance" value. The output can be subset to specific distances of interest e.g. k=0 and k=2 by supplying a vector to list.distance e.g. c(0,2) but this is optional. Specifying average.over="distance", you can opt to average within segments of distance using the periods argument (leaving this blank will average over all distance values). The periods argument requires a list of contiguous numeric vectors e.g. list(0,1:4,5:10). For Diagnostic 3 this would report metrics at time t, averages over times t-1 to t-4, and averages over times t-5 to t-10. For Diagnostics 1 and 3 the entire range should lie between 0 and t. For Diagnostic 2 the entire range should lie between 1 and t.
}
\examples{
# This example uses the included "example_sml.rda" data set

diagnose(input=example_sml,
         diagnostic=1,
         censoring="no",
         approach="none",
         scope="all",
         id="id",
         times.exposure=c(0,1,2),
         times.covariate=c(0,1,2),
         exposure="a",
         temporal.covariate=c("l","m","n"),
         static.covariate=c("o", "p"),
         sort.order="alphabetical",
         history="h",
         ignore.missing.metric="no",
         loop="yes",
         sd.ref="no")
}
