% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_sponsor_list.R
\name{sen_bill_sponsors}
\alias{sen_bill_sponsors}
\title{Downloads and tidies data on the bill sponsors in the Federal Senate}
\usage{
sen_bill_sponsors(ascii = TRUE)
}
\arguments{
\item{ascii}{(\code{logical}). If TRUE, bill sponsor names are converted
to ascii format, stripping the latin characters from the names.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame},
with variables:
\itemize{
 \item{\code{sponsor_name: }}{identity of the bill sponsor.}
 \item{\code{sponsor_code: }}{code for senator bill sponsors.}
 \item{\code{sponsor_title: }}{title of bill sponsor.}
 \item{\code{sponsor_party: }}{party of bill sponsor.}
 \item{\code{sponsor_state: }}{state of bill sponsor.}
 \item{\code{quantity: }}{quantity of bills sponsored by this individual or entity.}
}
}
\description{
Downloads and tidies data on the bill sponsors in the Federal Senate.
}
\examples{
\donttest{
bills <- sen_bill_sponsors()
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
