% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acl.R
\name{get_acl_user}
\alias{get_acl_user}
\alias{get_acl_group}
\alias{get_acl}
\alias{get_acl_user_role}
\alias{get_acl_group_role}
\title{Get ACL Details}
\usage{
get_acl_user(content)

get_acl_group(content)

get_acl(content)

get_acl_user_role(content, user_guid)

get_acl_group_role(content, group_guid)
}
\arguments{
\item{content}{\link{Content} An R6 Content item as returned from \code{content_item()}}

\item{user_guid}{\link{character} A user guid. Get user guids using \code{get_users()}}

\item{group_guid}{\link{character} A group guid. Get group guids using
\code{get_groups()}}
}
\value{
A list of users/groups who have access to the content
}
\description{
\lifecycle{deprecated} Retrieve the Access Controls associated with a given
piece of content. Deprecated in favor of \code{\link[=content_add_user]{content_add_user()}} or \link{permissions}.
}
\details{
NOTE: ACLs can still be stored, even when access_type for content is "all" or
"logged_in" users. In these cases, granting or removing "viewer" privileges
have no effect.
\itemize{
\item \code{get_acl_user()} returns user ACLs
\item \code{get_acl_group()} returns group ACLs
\item \code{get_acl_user_role()} returns the "role" for a
particular user on a piece of content
\item \code{get_acl_group_role()} returns the "role" for a
particular group on a piece of content
}

\code{get_acl()} is deprecated.
}
\seealso{
Other content functions: 
\code{\link{acl_add_user}()},
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url_chr}()},
\code{\link{dashboard_url}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_jobs}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
