% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectors.R
\name{datasources}
\alias{datasources}
\title{Extract data sources from connectors}
\usage{
datasources(connectors)
}
\arguments{
\item{connectors}{An object containing connectors with a "datasources" attribute.}
}
\value{
An object containing the data sources extracted from the "datasources" attribute.
}
\description{
This function extracts the "datasources" attribute from a connectors object.
}
\details{
The function uses the \code{attr()} function to access the "datasources" attribute
of the \code{connectors} object. It directly returns this attribute without any
modification.
}
\examples{
# Assume we have a 'mock_connectors' object with a 'datasources' attribute
mock_connectors <- structure(list(), class = "connectors")
attr(mock_connectors, "datasources") <- list(source1 = "data1", source2 = "data2")

# Using the function
result <- datasources(mock_connectors)
print(result)

}
