% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist2All_df.R
\name{dist2All_df}
\alias{dist2All_df}
\title{Calculate Distances Between All Individuals}
\usage{
dist2All_df(
  x = NULL,
  id = NULL,
  dateTime = NULL,
  point.x = NULL,
  point.y = NULL,
  poly.xy = NULL,
  elev = NULL,
  parallel = FALSE,
  nCores = (parallel::detectCores()/2),
  dataType = "Point",
  lonlat = FALSE,
  numVertices = 4
)
}
\arguments{
\item{x}{Data frame or list of data frames containing real-time-location 
data.}

\item{id}{Vector of length nrow(data.frame(x)) or singular character data, 
detailing the relevant colname in x, that denotes what unique ids for 
tracked individuals will be used. If argument == NULL, the function 
assumes a column with the colname "id" exists in x. Defaults to NULL.}

\item{dateTime}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what dateTime 
information will be used. If argument == NULL, the function assumes a 
column with the colname "dateTime" exists in x. Defaults to NULL.}

\item{point.x}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-x or 
longitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "x" exists in x. Defaults to 
NULL.}

\item{point.y}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-y or 
lattitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "y" exists in x. Defaults to 
NULL.}

\item{poly.xy}{Columns within x denoting polygon xy-coordinates. Polygon 
coordinates must be arranged in the format of those in 
referencePointToPolygon output. Defaults to NULL.}

\item{elev}{Vector of length nrow(data.frame(x)) or singular character data,
detailing the relevant colname in x, that denotes vertical positioning of
each individual in 3D space (e.g., elevation).  If argument != NULL, 
relative vertical positioning will be incorporated into distance 
calculations. Defaults to NULL.}

\item{parallel}{Logical. If TRUE, sub-functions within the dist2All wrapper 
will be parallelized. Defaults to FALSE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half of the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}

\item{dataType}{Character string refering to the type of real-time-location 
data presented in x, taking values of "Point" or "Polygon." If 
argument == "Point," individuals' locations are drawn from point.x and 
point.y. If argument == "Polygon," individuals' locations are drawn from 
poly.xy. Defaults to "Point."}

\item{lonlat}{Logical. If TRUE, point.x and point.y contain geographic 
coordinates (i.e., longitude and lattitude). If FALSE, point.x and 
point.y contain planar coordinates. Defaults to FALSE.}

\item{numVertices}{Numerical. If dataType == "Polygon," users must specify 
the number of vertices contained in each polygon. Defaults to 4. Note: 
all polygons must contain the same number of vertices.}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{dateTime}{The unique date-time information corresponding to when
   tracked individuals were observed in \code{x}.}
   \item{totalIndividuals}{The total number of individuals observed at least
   one time within \code{x}.}
   \item{individualsAtTimestep}{The number of individuals in \code{x}  
   observed at the timepoint described in the \code{dateTime} column.}    
   \item{id}{The unique ID of a tracked individual for which we will 
   evaluate distances to all other individuals observed in \code{x}.}
   \item{dist.to.indiv_...}{The observed distance between the individual 
   described in the \code{id} column to every other individual observed 
   at specific timepoints.}
}
\description{
Calculates the distance between all tracked individuals at a given timestep.
   Users can choose whether to calculate distances based on a single point, 
   or polygons representative of individuals' locations. If individuals set 
   dataType == "Polygon", the distance matrix reported describes the 
   shortest distances between polygons' edges (Note that the 
   rgeos::gDistance function is used to obtain these distances).
}
\details{
If dataType == "Point," users have the option of setting lonlat == TRUE 
   (by default lonlat == FALSE). lonlat is a logical argument that tells the
   function to calculate the distance between points on the WGS ellipsoid 
   (if lonlat == TRUE), or on a plane (lonlat == FALSE) 
   (see raster::pointDistance). If lonlat == TRUE, coordinates should be in 
   degrees. Otherwise, coordinates should represent planar ('Euclidean') 
   space (e.g. units of meters).This function is not currently able to 
   calculate distances between polygons on the WGS ellipsoid (i.e., if 
   dataType == "Polygon," lonlat must = FALSE). We aim to address this issue
   in future versions.

Note that if inputting a separate matrix/dataframe with polygon xy 
   coordinates (poly.xy), coordinates must be arranged in the format of 
   those in referencePointToPolygon outputs (i.e., col1 = point1.x, 
   col2 = point1.y, col3 =point2.x, col4 = point2.y, etc., with points 
   listed in a clockwise (or counter-clockwise) order).
}
\examples{
data(calves)

calves.dateTime<-datetime.append(calves, date = calves$date,
   time = calves$time)

calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag,
   dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x,
   point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE,
   extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE,
   na.rm = TRUE, smooth.type = 1) #smooth locations to 5-min fix intervals.

calves.dist2<-dist2All_df(x = calves.agg, parallel = FALSE, dataType = "Point",
   lonlat = FALSE) #calculate distance between all individuals at each timepoint.

}
\keyword{GRC}
\keyword{data-processing}
\keyword{location}
\keyword{planar}
\keyword{point}
\keyword{polygon}
