% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist2Area_df.R
\name{dist2Area_df}
\alias{dist2Area_df}
\title{Calculate Distances Between Individuals and Fixed Points/Polygons}
\usage{
dist2Area_df(
  x = NULL,
  y = NULL,
  x.id = NULL,
  y.id = NULL,
  dateTime = NULL,
  point.x = NULL,
  point.y = NULL,
  poly.xy = NULL,
  parallel = FALSE,
  nCores = (parallel::detectCores()/2),
  dataType = "Point",
  lonlat = FALSE,
  numVertices = 4
)
}
\arguments{
\item{x}{Data frame or list of data frames containing real-time-location 
data for individuals.}

\item{y}{Data frame or list of data frames describing fixed-area 
polygons/points for which we will calculate distances relative to tracked
individuals at all time steps. Polygons contained within the same data 
frame must have the same number of vertices.}

\item{x.id}{Vector of length nrow(data.frame(x)) or singular character data,
detailing the relevant colname in x, that denotes what unique ids for 
tracked individuals will be used. If argument == NULL, the function 
assumes a column with the colname "id" exists in x. Defaults to NULL.}

\item{y.id}{Vector of length sum(nrow(data.frame(y[1:length(y)]))) or 
singular character data, detailing the relevant colname in y, that 
denotes what unique ids for fixed-area polygons/points will be used. If 
argument == NULL, the function assumes a column with the colname "id" may
exist in y. If such a column does exist, fixed-area polygons will be 
assigned unique ids based on values in this column. If no such column 
exists, fixed-area polygons/points will be assigned sequential numbers as
unique identifiers. Defaults to NULL.}

\item{dateTime}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what dateTime 
information will be used. If argument == NULL, the function assumes a 
column with the colname "dateTime" exists in x. Defaults to NULL.}

\item{point.x}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-x or 
longitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "x" exists in x. Defaults to 
NULL.}

\item{point.y}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-y 
or lattitude coordinate information will be used. If argument == NULL, 
the function assumes a column with the colname "y" exists in x. 
Defaults to NULL.}

\item{poly.xy}{Columns within x denoting polygon xy-coordinates. Polygon 
coordinates must be arranged in the format of those in 
referencePointToPolygon output. Defaults to NULL.}

\item{parallel}{Logical. If TRUE, sub-functions within the dist2Area_df 
wrapper will be parallelized. Note that this can significantly speed up 
processing of relatively small data sets, but may cause R to crash due to
lack of available memory when attempting to process large datasets. 
Defaults to FALSE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half og the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}

\item{dataType}{Character string refering to the type of real-time-location 
data presented in x, taking values of "Point" or "Polygon." If 
argument == "Point," individuals' locations are drawn from point.x and 
point.y. If argument == "Polygon," individuals' locations are drawn from 
poly.xy. Defaults to "Point."}

\item{lonlat}{Logical. If TRUE, point.x and point.y contain geographic 
coordinates (i.e., longitude and lattitude). If FALSE, point.x and 
point.y contain planar coordinates. Defaults to FALSE.}

\item{numVertices}{Numerical. If dataType == "Polygon," users must specify 
the number of vertices contained in each polygon described in x. 
Defaults to 4. Note: all polygons must contain the same number of 
vertices.}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{dateTime}{The unique date-time information corresponding to when
   tracked individuals were observed in \code{x}.}
   \item{totalIndividuals}{The total number of individuals observed at least
   one time within \code{x}.}
   \item{individualsAtTimestep}{The number of individuals in \code{x}  
   observed at the timepoint described in the \code{dateTime} column.}    
   \item{id}{The unique ID of a tracked individual for which we will 
   evaluate distances to all other individuals observed in \code{x}.}
   \item{dist.to...}{The observed distance between the individual 
   described in the \code{id} column to every each polygon/fixed location}
}
\description{
Calculate distances (either planar or great circle - see dist2All_df) 
   between each individual, reported in x, and a fixed point(s)/polygon(s), 
   reported in y, at each timestep.
}
\details{
Polygon coordinates (in both x and y inputs) must be arranged in the format 
   of those in referencePointToPolygon outputs (i.e., col1 = point1.x, 
   col2 = point1.y, col3 =point2.x, col4 = point2.y, etc., with points 
   listed in a clockwise (or counter-clockwise) order).
   
This variant of dist2Area requires x and y inputs to be non-shapefile data.
}
\examples{
data(calves)

calves.dateTime<-datetime.append(calves, date = calves$date, 
  time = calves$time) #create a dataframe with dateTime identifiers for location fixes.

calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag, 
   dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x, 
   point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE, 
   extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE, 
   na.rm = TRUE, smooth.type = 1) #smooth to 5-min fix intervals.

water<- data.frame(x = c(61.43315, 61.89377, 62.37518, 61.82622),
                  y = c(62.44815, 62.73341, 61.93864, 61.67411)) #delineate water polygon

water_poly<-data.frame(matrix(ncol = 8, nrow = 1)) #make coordinates to dist2Area specifications
colnum = 0
for(h in 1:nrow(water)){
 water_poly[1,colnum + h] <- water$x[h] #pull the x location for each vertex
 water_poly[1, (colnum + 1 + h)] <- water$y[h] #pull the y location for each vertex
 colnum <- colnum + 1
}

water_dist<-dist2Area_df(x = calves.agg, y = water_poly, 
  x.id = calves.agg$id, y.id = "water", dateTime = "dateTime", point.x = calves.agg$x, 
  point.y = calves.agg$y, poly.xy = NULL, parallel = FALSE, dataType = "Point", 
  lonlat = FALSE, numVertices = NULL) 
}
\keyword{GRC}
\keyword{data-processing}
\keyword{location}
\keyword{planar}
\keyword{point}
\keyword{polygon}
