% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_history.R
\name{query_history}
\alias{query_history}
\title{List all content identifiers that have been seen at a given URL}
\usage{
query_history(url, registries = default_registries(), ...)
}
\arguments{
\item{url}{A URL for a data file}

\item{registries}{list of registries at which to register the URL}

\item{...}{additional arguments}
}
\value{
a data frame with all content identifiers that have been seen
at a given URL.  If the URL is version-stable, this should be a single
identifier.  Note that if multiple identifiers are listed, older content
may no longer be available, though there is a chance it has been registered
to a different url and can be resolved with \link{query_sources}.
}
\description{
\link{query_history} is the complement of \link{query_sources}, in that it filters a table
of content identifier : url : date entries by the url.
}
\examples{
\dontshow{ ## Real users won't use a temporary dir
Sys.setenv("CONTENTID_REGISTRIES" = tempdir())
}

\donttest{ 
query_history(paste0("https://knb.ecoinformatics.org/knb/d1/mn/v2/object/",
"ess-dive-457358fdc81d3a5-20180726T203952542"))
}

\dontshow{ ## Real users won't use a temporary dir
Sys.unsetenv("CONTENTID_REGISTRIES")
}


}
\seealso{
sources
}
