% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_cond_midP_unspecific_ordering_rx2.R
\name{Exact_cond_midP_unspecific_ordering_rx2}
\alias{Exact_cond_midP_unspecific_ordering_rx2}
\title{The exact conditional and mid-P tests for unspecific ordering}
\usage{
Exact_cond_midP_unspecific_ordering_rx2(
  n,
  direction,
  statistic = "Pearson",
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed counts (an rx2 matrix)}

\item{direction}{the direction of the success probabilities ("increasing"
or "decreasing")}

\item{statistic}{the Pearson test statistic ("Pearson") or the likelihood
ratio test statistic ("LR"). Can also be used for cumulative ORs in
2xc tables with "PearsonCumOR" or "LRCumOR".}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
A data frame containing the two-sided exact P-value and the mid-P value
}
\description{
The exact conditional and mid-P tests for unspecific ordering.
May also be used for 2xc tables, after flipping rows and columns (i.e. if
n is a 2xc table, call this function with n' (the transpose of n) as
the first argument).

Described in Chapter 5 "The Ordered rx2 Table"
}
\examples{
# Chapter 6: Postoperative nausea (Lydersen et al., 2012a)
n <- t(rbind(c(14, 10, 3, 2), c(11, 7, 8, 4)))
Exact_cond_midP_unspecific_ordering_rx2(n, "decreasing")
\dontrun{
    Exact_cond_midP_unspecific_ordering_rx2(n, "decreasing", "PearsonCumOR")
}
}
