% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateArguments.R
\name{validateArguments}
\alias{validateArguments}
\title{Validate arguments of a function}
\usage{
validateArguments(x, types = "default")
}
\arguments{
\item{x}{named list containing function arguments and their values}

\item{types}{named vector of types for \code{x}}
}
\value{
Nothing if all aguments fit their type. An error message otherwise.
}
\description{
This is an internal function used by user-level functions to
validate their arguments.
}
\details{
Accepted validation types are:
\itemize{
\item "counts"
\item "positive"
\item "probability"
\item "linear, log or logit"
\item "MH or IV"
\item "logit or probit"
\item "increasing or decreasing"
\item A vector of possible values
}
}
\note{
Types are evaluated alphabetically, and errors accuse no more than
one invalid argument at a time.
}
\examples{
Adjusted_inv_sinh_CI_OR_2x2(ritland_2007)
\dontrun{Adjusted_inv_sinh_CI_OR_2x2(-ritland_2007)}

}
\author{
Waldir Leoncio
}
