% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_conv.R
\name{beta_conv}
\alias{beta_conv}
\title{Beta-convergence statistic}
\usage{
beta_conv(
  tavDes,
  time_0,
  time_t,
  all_within = FALSE,
  timeName = "time",
  useTau = TRUE
)
}
\arguments{
\item{tavDes}{the sorted dataframe time by countries on the original scale.
No other variable besides time and countries' indicator
must be present.}

\item{time_0}{reference time.}

\item{time_t}{target time strictly larger than time_0.}

\item{all_within}{is FALSE if just two different years are considered (default);
if  more than two years  are desired within the
specified interval then it must be  TRUE ; the reference time remains
time_0.}

\item{timeName}{the name of the variable that contains time information.}

\item{useTau}{if TRUE the log ratio of indicator values is divided for
the elapsed time (years).}
}
\value{
a list with the value of beta-conv, by OLS (least-squares), the
        transformed data and standard statistical tests.
}
\description{
Given a dataframe of quantitative indicators along time,
the unconditional beta convergence is a statistic
capturing some important features.
A time variable must be present and sorted.
Missing values are not allowed. All other columns are indicator values
in each considered country.
}
\examples{

# Example 1:
# Dataframe in the format years by countries:
require(tibble)
myTB1  <- tibble::tribble(
  ~years, ~UK, ~DE, ~IT,
  1990,   998,  1250, 332,
  1988,   1201, 868, 578,
  1989,   1150, 978, 682,
  1991,  1600,  1350, 802
)

# Sort the time variable:
newdata <- myTB1[order(myTB1$years),]

# Beta convergence statistic by considering just two times, e.g. 1989 and 1991:
myBC1 <- beta_conv(newdata,1989,1991,timeName="years")

# Visualize the summary of the results (estimated coefficients, standard errors, p-values):
myBC1$res$summary

# Visualize the adjusted R-squared:
myBC1$res$adj.r.squared

# Beta convergence statistic by considering more than two times:
myBC2 <- beta_conv(newdata,1988,1991,all_within=TRUE,timeName="years")

# Example 2:
# Dataframe in the format years by countries, time variable already sorted:
testTB <- tribble(
    ~time, ~countryA ,  ~countryB,  ~countryC,
    2000,     0.8,   2.7,    3.9,
    2001,     1.2,   3.2,    4.2,
    2002,     0.9,   2.9,    4.1,
    2003,     1.3,   2.9,    4.0,
    2004,     1.2,   3.1,    4.1,
    2005,     1.2,   3.0,    4.0
    )
myBC3 <- beta_conv(testTB, time_0 = 2000, time_t = 2005, timeName = "time")
myBC4 <- beta_conv(testTB, time_0 = 2000, time_t = 2005, all_within = TRUE, timeName = "time")

# Example 3
# Beta convergence for the emp_20_64_MS Eurofound dataset:
data(emp_20_64_MS)
empBC <- beta_conv(emp_20_64_MS, time_0 = 2002, time_t = 2006, timeName = "time")

# Summary of the model results:
empBC$res$summary

# Adjusted R-squared:
empBC$res$adj.r.squared


}
\references{
{ \url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
