% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svypoormed.R
\name{svypoormed}
\alias{svypoormed}
\alias{svypoormed.DBIsvydesign}
\alias{svypoormed.survey.design}
\alias{svypoormed.svyrep.design}
\title{Relative median poverty gap}
\usage{
svypoormed(formula, design, ...)

\method{svypoormed}{survey.design}(formula, design, order = 0.5,
  percent = 0.6, na.rm = FALSE, ...)

\method{svypoormed}{svyrep.design}(formula, design, order = 0.5,
  percent = 0.6, na.rm = FALSE, ...)

\method{svypoormed}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{order}{income quantile order, usually .5}

\item{percent}{fraction of the quantile, usually .60}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the median of incomes less than the at-risk-of-poverty threshold (\code{arpt}).
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
\dontrun{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

svypoormed( ~eqincome , design = des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

svypoormed( ~eqincome , design = des_eusilc_rep )

# linearized design using a variable with missings
svypoormed( ~ py010n , design = des_eusilc )
svypoormed( ~ py010n , design = des_eusilc , na.rm = TRUE )
# replicate-weighted design using a variable with missings
svypoormed( ~ py010n , design = des_eusilc_rep )
svypoormed( ~ py010n , design = des_eusilc_rep , na.rm = TRUE )

# library(MonetDBLite) is only available on 64-bit machines,
# so do not run this block of code in 32-bit R

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 , 
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

svypoormed( ~ eqincome , design = dbd_eusilc )

dbRemoveTable( conn , 'eusilc' )

}

}
\author{
Djalma Pessoa and Anthony Damico
}
\references{
Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{http://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{http://www5.statcan.gc.ca/bsolc/olc-cel/olc-cel?lang=eng&catno=12-001-X19990024882}.
}
\seealso{
\code{\link{svyarpt}}
}
\keyword{survey}

