% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svybcc.R
\name{svybcc}
\alias{svybcc}
\alias{svybcc.survey.design}
\alias{svybcc.svyrep.design}
\alias{svybcc.DBIsvydesign}
\title{Bourguignon-Chakravarty multidimensional poverty class (EXPERIMENTAL)}
\usage{
svybcc(formula, design, ...)

\method{svybcc}{survey.design}(formula, design, theta = 0.5, alpha = 0.5,
  cutoffs, dimw = NULL, na.rm = FALSE, ...)

\method{svybcc}{svyrep.design}(formula, design, theta = 0.5, alpha = 0.5,
  cutoffs, dimw = NULL, na.rm = FALSE, ...)

\method{svybcc}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the variables. Variables can be numeric or ordered factors.}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{theta}{a scalar defining the elasticity of substitution between the normalized gaps of the attributes.}

\item{alpha}{a scalar that can be interpreted as the society's aversion to poverty.}

\item{cutoffs}{a list defining each variable's deprivation limit.}

\item{dimw}{a vector defining the weight of each dimension in the multidimensional deprivation sum.}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate indices from the Bourguignon-Chakravarty class, a class of poverty measures.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to changes in later versions.
}
\examples{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)
des_eusilc <- update(des_eusilc, pb220a = ordered( pb220a ) )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

# cutoffs
cos <- list( 10000, 5000 )

# variables without missing values
svybcc( ~ eqincome + hy050n , design = des_eusilc , cutoffs = cos )
svybcc( ~ eqincome + hy050n , design = des_eusilc_rep , cutoffs = cos )

# subsetting:
sub_des_eusilc <- subset( des_eusilc, db040 == "Styria")
sub_des_eusilc_rep <- subset( des_eusilc_rep, db040 == "Styria")

svybcc( ~ eqincome + hy050n , design = sub_des_eusilc , cutoffs = cos )
svybcc( ~ eqincome + hy050n , design = sub_des_eusilc_rep , cutoffs = cos )

\dontrun{

# including factor variable with missings
cos <- list( 10000, 5000, "EU" )
svybcc(~eqincome+hy050n+pb220a, des_eusilc, cutoffs = cos, na.rm = FALSE )
svybcc(~eqincome+hy050n+pb220a, des_eusilc, cutoffs = cos, na.rm = TRUE )
svybcc(~eqincome+hy050n+pb220a, des_eusilc_rep, cutoffs = cos, na.rm = FALSE )
svybcc(~eqincome+hy050n+pb220a, des_eusilc_rep, cutoffs = cos, na.rm = TRUE )

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )
dbd_eusilc <- update( dbd_eusilc, pb220a = ordered( pb220a ) )

# cutoffs
cos <- list( 10000 , 5000 )

# variables without missing values
svybcc(~eqincome+hy050n, design = dbd_eusilc, cutoffs = cos )

# subsetting:
sub_dbd_eusilc <- subset( dbd_eusilc, db040 == "Styria")
svybcc(~eqincome+hy050n, design = sub_dbd_eusilc, cutoffs = cos )

# cutoffs
cos <- list( 10000, 5000, "EU" )

# including factor variable with missings
svybcc(~eqincome+hy050n+pb220a, dbd_eusilc, cutoffs = cos, na.rm = FALSE )
svybcc(~eqincome+hy050n+pb220a, dbd_eusilc, cutoffs = cos, na.rm = TRUE )

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Francois Bourguignon and Satya R. Chakravarty (2003). The measurement of multidimensional poverty.
Journal of Economic Inequality, v. 1, n. 1, April 2003, pp. 1-25.
URL \url{http://dx.doi.org/10.1023/A:1023913831342}.

Maria Casilda Lasso de la Vega, Ana Urrutia and Henar Diez (2009). The Bourguignon and Chakravarty multidimensional poverty family: a characterization.
Working Papers 109, ECINEQ, Society for the Study of Economic Inequality.
}
\seealso{
\code{\link{svyafc}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
