% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorbar.R
\name{colorbar}
\alias{colorbar}
\title{Vertical color bar}
\usage{
colorbar(
  xleft,
  ybottom,
  xright,
  ytop,
  col = gray.colors(256, 0, 1),
  n = length(col),
  clim = c(0, 1),
  show.border = TRUE,
  text = "",
  line = 2,
  show.axis = TRUE,
  side = "right",
  lwd = 1,
  nticks = 5,
  at = NULL,
  ...
)
}
\arguments{
\item{xleft}{left x-coordinate of the bar}

\item{ybottom}{bottom y-coordinate of the bar}

\item{xright}{right x-coordinate of the bar}

\item{ytop}{top y-coordinate of the bar}

\item{col}{vector of colors}

\item{n}{number of polygons used to draw the bar}

\item{clim}{2-vector specifying the range of values, linearly represented by the full color scale}

\item{show.border}{logical flag specifying whether to draw a rectangular border around the bar}

\item{text}{axis label}

\item{line}{distance between label and color bar}

\item{show.axis}{logical flag specifying whether to draw an axis}

\item{side}{character string, which specifies the location of the axis on the bar. This has to be 'left' or 'right' (default).}

\item{lwd}{linewidth of border and ticks}

\item{nticks}{number of ticks on the axis}

\item{at}{vector of values specifying the tick positions on the axis, this overrides nticks.}

\item{...}{optional arguments to be passed to the function \code{\link{axis}}}
}
\value{
None
}
\description{
Adds a vertical color bar to a plot with a custom axis.
}
\examples{
## Plot a spherical function with color bar
nplot(xlim=c(0,1.2), asp=1)
f = function(theta,phi) cos(10*theta+phi)
sp = sphereplot(f, 200, col=planckcolors(200), phi0=0.1, theta0=pi/3,
add=TRUE, center=c(0.5,0.5), radius=0.4, clim=c(-1,1))
colorbar(1,0.1,1.1,0.9,col=sp$col,clim=sp$clim)

}
\author{
Danail Obreschkow
}
