% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covar.r
\name{covar}
\alias{covar}
\title{Covariance}
\usage{
covar(x, y, use = "everything")
}
\arguments{
\item{x}{A numeric matrix or vector.}

\item{y}{A vector (when \code{x} is a vector) or missing (blank) when 
\code{x} is a matrix.}

\item{use}{The NA handler, as in R's \code{cov()} and \code{cor()}
functions.  Options are "everything", "all.obs", and 
"complete.obs".}
}
\value{
The covariance matrix.
}
\description{
An optimized, efficient implemntation for computing covariance.
}
\details{
See \code{?coop-package} for implementation details.
}
\examples{
x <- matrix(rnorm(10*3), 10, 3)

coop::pcor(x)
coop::pcor(x[, 1], x[, 2])

}
\author{
Drew Schmidt
}
\seealso{
\code{\link{cosine}}
}

