% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R, R/mdp.R
\name{[[.mdpolya_result}
\alias{[[.mdpolya_result}
\alias{mdp}
\title{Marginal MDP Sampler}
\usage{
\method{[[}{mdpolya_result}(obj, i)

mdp(
  data,
  k,
  alpha = 1,
  mu = 21,
  tau = 25,
  s = 4,
  S = 2,
  c = 2,
  C = 4,
  a = 21,
  A = 21,
  w = 1,
  W = 100,
  fix_a = FALSE,
  fix_m = FALSE,
  fix_t = FALSE,
  burn = 1000,
  thin = 150
)
}
\arguments{
\item{obj}{An \code{mdpolya_result} object.}

\item{i}{A numeric vector of sample indices.}

\item{data}{A numeric vector of \code{n} observation values.}

\item{k}{The number of sampling iterations to record, will be truncated if a
non-integer.}

\item{alpha}{The concentration parameter for the Dirichlet Process prior.}

\item{mu}{The mean parameter for the Normal-Inverse-Gamma prior.}

\item{tau}{The variance parameter for the Normal-Inverse-Gamma prior.}

\item{s}{The shape parameter for the Normal-Inverse-Gamma prior.}

\item{S}{The scale parameter for the Normal-Inverse-Gamma prior.}

\item{c}{The shape parameter for the Gamma prior on alpha.}

\item{C}{The scale parameter for the Gamma prior on alpha.}

\item{a}{The mean parameter for the Normal prior on mu.}

\item{A}{The variance parameter for the Normal prior on mu.}

\item{w}{The shape parameter for the Inverse-Gamma prior on tau.}

\item{W}{The scale parameter for the Inverse-Gamma prior on tau.}

\item{fix_a}{A logical value indicating whether or not to fix alpha at its
initial value.}

\item{fix_m}{A logical value indicating whether or not to fix mu at its
initial value.}

\item{fix_t}{A logical value indicating whether or not to fix tau at its
initial value.}

\item{burn}{The number of initial sampling iterations to discard, will be
truncated if a non-integer.}

\item{thin}{The number of sampling iterations to discard between records,
will be truncated if a non-integer.}
}
\value{
An \code{mdpolya_result} object. A list with four entries:
 * \code{theta}: An array of dimension \code{[k, n, 3]} encoding the
  component label, mean, and standard deviation for each data point for each
  iteration. This represents the samples from the Polya posterior
  distribution of the marginal MDP model.
 * \code{eta}: A matrix of dimension \code{[k, 5]} encoding the
  hyperparameter values for each iteration.
 * \code{args}: A list of input arguments.
 * \code{phi}: A list of matrices encoding the unique values from
  \code{theta} and associated weights for each iteration.
}
\description{
Marginal MDP Sampler
}
\section{Functions}{
\itemize{
\item \code{[[}: Subset method for \code{mdpolya_result} objects

}}
\examples{
res_mdp <- mdp(rnorm(50), 10)
}
\references{
\itemize{
 \item Moya B., Walker S. G. (2022). Uncertainty Quantification and the
 Marginal MDP Model. arXiv. DOI: \doi{10.48550/arxiv.2206.08418}
 \item Escobar M. D., West, M. (1995) Bayesian Density Estimation and
 Inference Using Mixtures. Journal of the American Statistical Association.
 DOI: \doi{10.1080/01621459.1995.10476550}
}
}
\seealso{
{[polya()]}
}
