% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rootSizeDir.R
\name{rootSizeDir}
\alias{rootSizeDir}
\title{Convert a directory of raw DICOM images to  root particle counts and surface areas}
\usage{
rootSizeDir(directory = file.choose(), 
diameter.classes = c(1, 2, 5, 10, 20),
class.names = diameter.classes,
means     = c(-850.3233, 63.912, 271.7827, 1345.0696),
sds       = c(77.6953, 14.1728, 39.2814, 45.4129),
densities = c(0.0012, 1, 1.23, 2.2),
pixel.minimum = 1)
}
\arguments{
\item{directory}{a character string that can be a matrix of DICOM images or the address of an individual DICOM file in a folder of DICOM images. The default action is <code>file.choose()</code>; a browser menu appears so the user can select the the desired directory by identifying a single DICOM file in the folder of images.}

\item{diameter.classes}{an integer vector of diameter cut points. Units are mm (zero is added in automatically).}

\item{class.names}{not used presently}

\item{means}{mean values (units = Hounsfield Units) for calibration rods used.}

\item{sds}{standard deviations (units = Hounsfield Units) for calibration rods used. Must be in the same order as \code{means}.}

\item{densities}{numeric vector of known cal rod densities. Must be in the same order as \code{means} and \code{sds}.}

\item{pixel.minimum}{minimum number of pixels needed for a clump to be identified as a root}
}
\value{
value \code{rootSize} returns a dataframe with one row per CT slice. Values returned are the number, volume (cm3), and surface area (cm2) of particles in each size class with an upper bound defined in \code{diameter.classes}.
}
\description{
Calculates the number of root/rhizome particles and surface areas, for different size classes
}
\details{
Calculates the number of root/rhizome particles and surface areas, for different size classes. Unlike \code{\link{rootSize}}, \code{\link{rootSizeDir}} accepts a folder of raw values and makes the conversion to Hounsfield Units using the metadata associated with the DICOM images.
}
\examples{
rootChars <- rootSizeDir("core_426", diameter.classes = c(2.5, 10))

\dontrun{
# plot using "ggplot" package after transforming with "reshape2" package
area.long <- reshape2::melt(rootChars, id.vars = c("depth"), 
   measure.vars = grep("Area", names(rootChars)))
ggplot2::ggplot(data = area.long, ggplot2::aes(y = -depth, x = value, 
   color = variable)) + ggplot2::geom_point() + ggplot2::theme_classic() + 
   ggplot2::xlab("root external surface area per slice (cm2)")
}

}
\seealso{
\code{\link{rootSizeDir}} is a wrapper for \code{\link{rootSize}}. \code{\link{rootSizeDir}} operates similarly.
}
