% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation_methods.r
\name{tCorpus$set_name}
\alias{tCorpus$set_name}
\alias{tCorpus$set_meta_name}
\alias{set_name}
\alias{set_meta_name}
\title{Change column names of data and meta data}
\arguments{
\item{oldname}{the current/old column name}

\item{newname}{the new column name}
}
\description{
Change column names of data and meta data
}
\section{Usage}{

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{set_name(oldname, newname)}
\preformatted{set_meta_name(oldname, newname)}
}

\examples{
tc = create_tcorpus(sotu_texts, doc_column = 'id')

## change column name in token data
tc$names ## original column names
tc$set_name(oldname = 'token', newname = 'word')
tc$get()

## change column name in meta data
tc$meta_names ## original column names
tc$set_meta_name(oldname = 'party', newname = 'clan')
tc$set_meta_name(oldname = 'president', newname = 'clan leader')
tc$get_meta()
}
