% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\docType{data}
\name{TSS}
\alias{TSS}
\title{The Use of Inflected or Uninflected Determiners in the Belgian Dutch Vernacular}
\format{A data frame with 40778 rows and 13 variables.
\itemize{
  \item{\code{Variant} }{The linguistic variant used in a set of alternatives (35 levels).}
  \item{\code{Variable} }{The linguistic variable specifying a set of alternatives (14 levels).}
  \item{\code{Inflected} }{Numeric variable specifying whether the linguistic variant is inflected (\code{1}) or not (\code{0}).}
  \item{\code{Register} }{The register of the data in the Spoken Dutch Corpus (14 levels: see 
    \href{http://lands.let.ru.nl/cgn/doc_English/topics/version_1.0/overview.htm}{here} for their definition).}
  \item{\code{Register2} }{The dichotomization of \code{Register} into private and public.}
  \item{\code{SpeakerID} }{The ID of the speaker in the Spoken Dutch Corpus (1144 levels).}
  \item{\code{Region} }{The region in which the speaker lived until the age of 18 (4 levels).}
  \item{\code{Sex} }{The sex of the speaker (2 levels).}
  \item{\code{BirthYear} }{The year in which the speaker was born (63 levels).}
  \item{\code{Decade} }{The decade in which the speaker was born (7 levels).}
  \item{\code{Generation} }{The generation cohort in which the speaker was born (5 levels).}
  \item{\code{Education} }{The level of education of the speaker (3 levels).}
  \item{\code{Occupation} }{The level of occupation of the speaker (10 levels: see 
    \href{http://lands.let.ru.nl/cgn/doc_English/topics/version_1.0/metadata/speakers.htm}{here} for their definition).}
}}
\source{
Plevoets, K. (2008) \emph{Tussen spreek- en standaardtaal}. Leuven, Doctoral dissertation. Available online \href{https://biblio.ugent.be/publication/1168055/file/1168056}{here}.
}
\description{
The distribution of the Belgian Dutch \emph{-e(n)}-suffix with 14 determiners in 14 registers and for several speaker characteristics.
}
\examples{
\donttest{
data(TSS)
# The execution of corregp may be slow, due to bootstrapping:  
tss.crg <- corregp(Variant ~ Register2 * Region, data = TSS, part = "Variable", b = 3000)
tss.crg
summary(tss.crg, parm = "b", add_ci = TRUE)
screeplot(tss.crg, add_ci = TRUE)
anova(tss.crg, nf = 2)
tss.col <- ifelse( xtabs(~ Variant + Inflected, data = TSS)[, 1] > 0, "blue", "red")
plot(tss.crg, x_ell = TRUE, xsub = c("Register2", "Region"), col_btm = tss.col, col_top = "black")
}
}
