% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{agplot.corregp}
\alias{agplot.corregp}
\alias{plotag.corregp}
\alias{agplot}
\alias{plotag}
\title{Plotting an Association Graph for Correspondence Regression}
\usage{
\method{agplot}{corregp}(x, axes = NULL, ysub = NULL, xsub = NULL,
  sort = NULL, na.rm = FALSE, col = "black", cex = par("cex"),
  font = par("font"), family = par("family"), lwd = par("lwd"),
  lty = par("lty"), ycol = col, xcol = col, ncol = c("white",
  "lightgray"), nwid = lwd, lcol = col, lwid = lwd, pcol = lcol,
  ppos = NULL, ptyp = "simple", zoom = 1, hshft = 0, vshft = 0,
  main = NULL, cl = 0.95, nq = TRUE, digits = 2, ...)

\method{plotag}{corregp}(x, axes = NULL, ysub = NULL, xsub = NULL,
  sort = NULL, na.rm = FALSE, col = "black", cex = par("cex"),
  font = par("font"), family = par("family"), lwd = par("lwd"),
  lty = par("lty"), ycol = col, xcol = col, ncol = c("white",
  "lightgray"), nwid = lwd, lcol = col, lwid = lwd, pcol = lcol,
  ppos = NULL, ptyp = "simple", zoom = 1, hshft = 0, vshft = 0,
  main = NULL, cl = 0.95, nq = TRUE, digits = 2, ...)

agplot(x, ...)

plotag(x, ...)
}
\arguments{
\item{x}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{axes}{The axes for which to plot the association graph: a vector of indices. Defaults to all the axes.}

\item{ysub}{Vector of indices to select a subset of the Y levels.}

\item{xsub}{Vector of indices to select a subset of the X levels. Can also be \code{"all"} or \code{"both"} (or abbreviations).}

\item{sort}{Vector of axes for which to sort the coordinate scores. The default (\code{NULL}) plots all levels in the order in which they appear in the
correspondence regression \code{x}.}

\item{na.rm}{Logical specifying whether to omit \code{NA} coordinates from the plot. Defaults to \code{FALSE}.}

\item{col}{Color of the association graph: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{cex}{Character expansion factor: a number to specify the size of the text labels.}

\item{font}{Font of the text labels (levels): \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic. Defaults to \code{1}.}

\item{family}{Font family of the text labels (levels): can be \code{"serif"}, \code{"sans"}, \code{"mono"} or one of the \code{\link[grDevices]{Hershey}} fonts.}

\item{lwd}{Line width of the association graph: a number to specify the line width.}

\item{lty}{Line type of the association graph (i.e. linking edges): \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"},
\code{3} or \code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{ycol}{Color of the levels in Y: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{xcol}{Color of the levels in X: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{ncol}{Fill color of the nodes: either \code{numeric} or see \code{\link[grDevices]{colors}}. Defaults to \code{c("white","lightgray")}: the first value
is for the nodes of the axes and the second value is for the nodes of the X and Y levels.}

\item{nwid}{Line width of the nodes: a number to specify the line width. If a vector of two values is specified, then the first width is for the nodes of
the axes and the second width is for the nodes of the X and Y levels.}

\item{lcol}{Color of the links (edges): either \code{numeric} or see \code{\link[grDevices]{colors}}. If a vector of two values is specified, then
the first color is for the scores \code{> 0} and the second color is for the scores \code{< 0}.}

\item{lwid}{Line width of the links (edges): a number to specify the line width. If a vector of two values is specified, then the first width is for
the scores \code{> 0} and the second width is for the scores \code{< 0}.}

\item{pcol}{Color of the pointer (arrow head): either \code{numeric} or see \code{\link[grDevices]{colors}}. If a vector of two values is specified, then
the first color is for the scores \code{> 0} and the second color is for the scores \code{< 0}.}

\item{ppos}{Relative position of the pointer (arrow head): a vector of values between 0 and 1 for each axis.}

\item{ptyp}{Type of of the pointer (arrow head): can be \code{"simple"}, \code{"curved"}, \code{"triangle"}, \code{"circle"}, \code{"ellipse"} or
\code{"T"}. Defaults to \code{"simple"}.}

\item{zoom}{Zoom factor of the association graph. Defaults to \code{1}.}

\item{hshft}{Horizontal shift of the association graph. Defaults to \code{0}.}

\item{vshft}{Vertical shift of the association graph. Defaults to \code{0}.}

\item{main}{The main title of the association graph.}

\item{cl}{The confidence level for the confidence intervals. Defaults to \code{0.95}.}

\item{nq}{Logical specifying whether to use a normal quantile (i.e. apply \code{\link[stats]{qnorm}}) in the computation of the confidence interval.
Defaults to \code{TRUE}. If \code{FALSE}, then the confidence interval is computed directly with the \code{\link[stats]{quantile}} function.}

\item{digits}{Integer specifying the number of decimals for the scores as labels of the links (edges). Defauls to \code{2}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A plot window containing the association graph.
}
\description{
Function to make an association graph of the (significant) coordinate scores in correspondence regression.
}
\details{
Association graphs (of a \code{corregp} output) in the \pkg{corregp} package make use of various functionalities of the package \pkg{diagram}.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
agplot(haireye.crg, axes = 1:2, xsub = c("Hair", "Sex"))
plotag(haireye.crg, axes = 1:2, xsub = c("Hair", "Sex"))
}
}
\seealso{
\code{\link{corregp}}, \code{\link{cint.corregp}}, \code{\link{pcplot.corregp}}, \code{\link{plot3d.corregp}}.
}
