% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{plot.corregp}
\alias{plot.corregp}
\title{Plotting Correspondence Regression}
\usage{
\method{plot}{corregp}(x, axes = 1:2, y_btm = TRUE, y_ell = FALSE,
  x_ell = FALSE, ysub = NULL, xsub = NULL, hlim = NULL, vlim = NULL,
  expa_btm = 1, expa_top = 1, asp = 1, asp_btm = asp, asp_top = asp,
  col_btm = "darkgrey", col_top = "red", cex_btm = par("cex"),
  cex_top = cex_btm, font_btm = par("font"), font_top = font_btm,
  fam_btm = par("family"), fam_top = fam_btm, col_ell = par("col"),
  lwd_ell = par("lwd"), lty_ell = par("lty"), col_ori = par("col"),
  lwd_ori = par("lwd"), lty_ori = 1, main = NULL, sub = NULL,
  hlab = NULL, vlab = NULL, cl = 0.95, np = 100, add_ori = TRUE, ...)
}
\arguments{
\item{x}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{axes}{The axes to plot: a vector of two values. Defaults to the first two axes.}

\item{y_btm}{Logical specifying whether the Y levels should be plotted first ("at the bottom") and then be overlaid by the X levels. Defaults to \code{TRUE}.}

\item{y_ell}{Logical specifying whether the confidence ellipses of the Y levels should be plotted. Defaults to \code{FALSE}.}

\item{x_ell}{Logical specifying whether the confidence ellipses of the X levels should be plotted. Defaults to \code{FALSE}.}

\item{ysub}{Vector of indices to select a subset of the Y levels.}

\item{xsub}{Vector of indices to select a subset of the X levels.}

\item{hlim}{Vector of two values specifying the lower and upper limit between which to plot the horizontal axis.}

\item{vlim}{Vector of two values specifying the lower and upper limit between which to plot the vertical axis.}

\item{expa_btm}{Expansion factor for the bottom coordinates: a number to rescale the axes.}

\item{expa_top}{Expansion factor for the top coordinates: a number to rescale the axes.}

\item{asp}{The aspect ratio for the whole plot. See \code{\link[graphics]{plot.window}}.}

\item{asp_btm}{The aspect ratio for the bottom coordinates. See \code{\link[graphics]{plot.window}}.}

\item{asp_top}{The aspect ratio for the top coordinates. See \code{\link[graphics]{plot.window}}.}

\item{col_btm}{Color of the bottom levels: either \code{numeric} or see \code{\link[grDevices]{colors}}. Defaults to \code{"darkgrey"}.}

\item{col_top}{Color of the top levels: either \code{numeric} or see \code{\link[grDevices]{colors}}. Defaults to \code{"red"}.}

\item{cex_btm}{Character expansion factor of the bottom levels: a number to specify the size of the text labels.}

\item{cex_top}{Character expansion factor of the top levels: a number to specify the size of the text labels.}

\item{font_btm}{Font of the bottom levels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic. Defaults to \code{1}.}

\item{font_top}{Font of the top levels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic. Defaults to \code{1}.}

\item{fam_btm}{Font family of the bottom levels: can be \code{"serif"}, \code{"sans"}, \code{"mono"} or one of the \code{\link[grDevices]{Hershey}} fonts.}

\item{fam_top}{Font family of the top levels: can be \code{"serif"}, \code{"sans"}, \code{"mono"} or one of the \code{\link[grDevices]{Hershey}} fonts.}

\item{col_ell}{Color of the confidence ellipses: either a number or see \code{\link[grDevices]{colors}}.}

\item{lwd_ell}{Width of the confidence ellipses: a number to specify the line width.}

\item{lty_ell}{Line type of the confidence ellipses: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or \code{"dotted"},
\code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{col_ori}{Color of the lines through the origin: either \code{numeric} or see \code{\link[grDevices]{colors}}.}

\item{lwd_ori}{Width of the lines through the origin: a number to specify the line width.}

\item{lty_ori}{Line type of the lines through the origin: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"},
\code{3} or \code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}. Defaults to \code{1}.}

\item{main}{The main title of the plot.}

\item{sub}{The subtitle of the plot.}

\item{hlab}{The title of the horizontal axis.}

\item{vlab}{The title of the vertical axis.}

\item{cl}{The confidence level for the confidence ellipses. Defaults to \code{0.95}.}

\item{np}{The number of points to represent the confidence ellipses. Defaults to \code{100}.}

\item{add_ori}{Logical specifying whether to add lines through the origin. Defaults to \code{TRUE}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A plot window containing the output of a correspondence regression.
}
\description{
Basic method to plot the output of a correspondence regression.
}
\details{
The plot of a correspondence regression is by definition a \code{\link[stats]{biplot}}.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
plot(haireye.crg, x_ell = TRUE, xsub = c("Hair", "Sex"))
}
}
\references{
Gower, J., S. Lubbe and N. Le Roux (2011) \emph{Understanding biplots}. Chichester: Wiley.

Greenacre, M. (2010) \emph{Biplots in practice}. Bilbao: Fundacion BBVA.
}
\seealso{
\code{\link{corregp}}, \code{\link{summary.corregp}}, \code{\link{screeplot.corregp}}, \code{\link{anova.corregp}}, \code{\link[stats]{biplot}}.
}
