% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{rplot}
\alias{rplot}
\title{Plot a correlation data frame.}
\usage{
rplot(rdf, legend = FALSE, shape = 16, colours = c("indianred2", "white",
  "skyblue1"), print_cor = FALSE, colors)
}
\arguments{
\item{rdf}{Correlation data frame (cor_df) created with \code{\link{correlate}}.}

\item{legend}{Boolean indicating whether a legend mapping the colours to the correlations should be displayed.}

\item{shape}{\code{\link{geom_point}} aesthetic.}

\item{colours, colors}{Vector of colours to use for n-colour gradient.}

\item{print_cor}{Boolean indicating whether the correlations should be printed over the shapes.}
}
\value{
Plots a correlation data frame
}
\description{
Plot a correlation data frame using ggplot2.
}
\examples{
x <- correlate(mtcars)
rplot(x)

# Common use is following rearrange and shave
x <- rearrange(x, absolute = FALSE)
x <- shave(x)
rplot(x)
rplot(x, print_cor = TRUE)
rplot(x, shape = 20, colors = c("red", "green"), legend = TRUE)
}

