% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_dot.R
\name{Dot}
\alias{Dot}
\title{Calculate pairwise dot products of counts between all cells.}
\usage{
Dot(C, subsample = FALSE)
}
\arguments{
\item{C}{countland object}

\item{subsample}{if TRUE, use subsampled counts, otherwise use counts (default=FALSE)}
}
\value{
countland object with slot \code{dots}
}
\description{
Calculate pairwise dot products of counts between all cells.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- Dot(C)
}
