% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_pixel.R
\name{pixel_morph}
\alias{pixel_morph}
\title{Pixel-level image morphing (final frame only)}
\usage{
pixel_morph(
  imgA,
  imgB,
  n_frames = 16L,
  mode = c("color_walk", "exact", "recursive"),
  lap_method = "jv",
  maximize = FALSE,
  quantize_bits = 5L,
  downscale_steps = 0L,
  alpha = 1,
  beta = 0,
  patch_size = 1L,
  upscale = 1,
  show = interactive()
)
}
\arguments{
\item{imgA}{Source image (file path or magick image object)}

\item{imgB}{Target image (file path or magick image object)}

\item{n_frames}{Internal parameter for rendering (default: 16)}

\item{mode}{Assignment algorithm: "color_walk" (default), "exact", or "recursive"}

\item{lap_method}{LAP solver method (default: "jv")}

\item{maximize}{Logical, maximize instead of minimize cost (default: FALSE)}

\item{quantize_bits}{Color quantization for "color_walk" mode (default: 5)}

\item{downscale_steps}{Number of 2x reductions before computing assignment (default: 0)}

\item{alpha}{Weight for color distance in cost function (default: 1)}

\item{beta}{Weight for spatial distance in cost function (default: 0)}

\item{patch_size}{Tile size for tiled modes (default: 1)}

\item{upscale}{Post-rendering upscaling factor (default: 1)}

\item{show}{Logical, display result in viewer (default: interactive())}
}
\value{
magick image object of the final transported frame
}
\description{
Computes optimal pixel assignment from A to B and returns the final
transported frame (without intermediate animation frames).
}
\details{
\subsection{Transport-Only Semantics}{

This function returns a SHARP, pixel-perfect transport of A's pixels
to positions determined by the assignment to B.

\strong{Key Points:}
\itemize{
\item Assignment computed using: \code{cost = alpha * color_dist + beta * spatial_dist}
\item B's COLORS influence assignment but DO NOT appear in output
\item Result has A's colors arranged to match B's layout
\item No motion blur (unlike intermediate frames in animation)
}

See \code{\link{pixel_morph_animate}} for detailed explanation of
assignment vs rendering semantics.
}

\subsection{Permutation Warnings}{

Assignment is guaranteed to be a bijection (permutation) ONLY when:
\itemize{
\item \code{downscale_steps = 0} (no resolution changes)
\item \code{mode = "exact"} with \code{patch_size = 1}
}

With downscaling or tiled modes, assignment may have:
\itemize{
\item \strong{Overlaps:} Multiple source pixels map to same destination (last write wins)
\item \strong{Holes:} Some destinations never filled (remain transparent)
}

If assignment is not a bijection (due to downscaling or tiling),
a warning will be issued. The result may contain:
\itemize{
\item Overlapped pixels (multiple sources -> one destination)
\item Transparent holes (some destinations unfilled)
}

For guaranteed pixel-perfect results, use:
\preformatted{
  pixel_morph(A, B, mode = "exact", downscale_steps = 0)
}
}
}
\examples{
if (requireNamespace("magick", quietly = TRUE)) {
  imgA <- system.file("extdata/icons/circleA_40.png", package = "couplr")
  imgB <- system.file("extdata/icons/circleB_40.png", package = "couplr")
  if (nzchar(imgA) && nzchar(imgB)) {
    result <- pixel_morph(imgA, imgB, n_frames = 4, show = FALSE)
  }
}

}
\seealso{
\code{\link{pixel_morph_animate}} for animated version
}
