% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_diagnostics.R
\name{standardized_difference}
\alias{standardized_difference}
\title{Calculate Standardized Difference}
\usage{
standardized_difference(x1, x2, pooled = TRUE)
}
\arguments{
\item{x1}{Numeric vector for group 1}

\item{x2}{Numeric vector for group 2}

\item{pooled}{Logical, if TRUE use pooled standard deviation (default),
if FALSE use group 1 standard deviation}
}
\value{
Numeric value representing the standardized difference
}
\description{
Computes the standardized mean difference between two groups.
This is a key metric for assessing balance in matched samples.
}
\details{
Standardized difference = (mean1 - mean2) / pooled_sd
where pooled_sd = sqrt((sd1^2 + sd2^2) / 2)

Common thresholds: less than 0.1 is excellent balance, 0.1-0.25 is good
balance, 0.25-0.5 is acceptable balance, and greater than 0.5 is poor balance.
}
\keyword{internal}
