% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covidcast.R
\name{covidcast_signals}
\alias{covidcast_signals}
\title{Obtain multiple COVIDcast signals at once}
\usage{
covidcast_signals(
  data_source,
  signal,
  start_day = NULL,
  end_day = NULL,
  geo_type = c("county", "hrr", "msa", "dma", "state", "hhs", "nation"),
  geo_values = "*",
  as_of = NULL,
  issues = NULL,
  lag = NULL
)
}
\arguments{
\item{data_source}{String identifying the data source to query. See
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}
for a list of available data sources.}

\item{signal}{String identifying the signal from that source to query. Again,
see \url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}
for a list of available signals.}

\item{start_day}{Query data beginning on this date. Date object, or string in
the form "YYYY-MM-DD". If \code{start_day} is \code{NULL}, defaults to first day data
is available for this signal.}

\item{end_day}{Query data up to this date, inclusive. Date object or string
in the form "YYYY-MM-DD". If \code{end_day} is \code{NULL}, defaults to the most
recent day data is available for this signal.}

\item{geo_type}{The geography type for which to request this data, such as
"county" or "state". Defaults to "county". See
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_geography.html}
for details on which types are available.}

\item{geo_values}{Which geographies to return. The default, "*", fetches all
geographies. To fetch specific geographies, specify their IDs as a vector
or list of strings. See
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_geography.html}
for details on how to specify these IDs.}

\item{as_of}{Fetch only data that was available on or before this date,
provided as a \code{Date} object or string in the form "YYYY-MM-DD". If \code{NULL},
the default, return the most recent available data. Note that only one of
\code{as_of}, \code{issues}, and \code{lag} should be provided; it does not make sense to
specify more than one. For more on data revisions, see
"Issue dates and revisions" below.}

\item{issues}{Fetch only data that was published or updated ("issued") on
these dates. Provided as either a single \code{Date} object (or string in the
form "YYYY-MM-DD"), indicating a single date to fetch data issued on, or a
vector specifying two dates, start and end. In this case, return all data
issued in this range. There may be multiple rows for each observation,
indicating several updates to its value. If \code{NULL}, the default, return the
most recently issued data.}

\item{lag}{Integer. If, for example, \code{lag = 3}, then we fetch only data that
was published or updated exactly 3 days after the date. For example, a row
with \code{time_value} of June 3 will only be included in the results if its
data was issued or updated on June 6. If \code{NULL}, the default, return the
most recently issued data regardless of its lag.}
}
\value{
A list of \code{covidcast_signal} data frames, of length \code{N = max(length(data_source), length(signal))}. This list can be aggregated
into a single data frame of either "wide" or "long" format using
\code{aggregate_signals()}.
}
\description{
This convenience function uses \code{covidcast_signal()} to obtain multiple
signals, potentially from multiple data sources.
}
\details{
The argument structure is just as in \code{covidcast_signal()}, except
the first four arguments \code{data_source}, \code{signal}, \code{start_day}, \code{end_day}
are permitted to be vectors. The first two arguments \code{data_source} and
\code{signal} are recycled appropriately in the calls to \code{covidcast_signal()};
see example below. The next two arguments \code{start_day}, \code{end_day}, unless
\code{NULL}, must be either length 1 or N.

See \code{vignette("multi-signals")} for additional examples.
}
\examples{
\dontrun{
## Fetch USAFacts confirmed cases and deaths over the same time period
covidcast_signals("usa-facts", signal = c("confirmed_incidence_num",
                                          "deaths_incidence_num"),
                   start_day = "2020-08-15", end_day = "2020-10-01")
}
}
\seealso{
\code{\link[=covidcast_signal]{covidcast_signal()}}, \code{\link[=aggregate_signals]{aggregate_signals()}}
}
