% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{state_fips_to_name}
\alias{state_fips_to_name}
\alias{county_fips_to_name}
\alias{cbsa_to_name}
\title{Get state, county or metropolitan area names from FIPS or CBSA codes}
\usage{
state_fips_to_name(code)

county_fips_to_name(code)

cbsa_to_name(code)
}
\arguments{
\item{code}{Vector of FIPS or CBSA codes to look up.}
}
\value{
A vector of state, county or metro names.
}
\description{
Look up county or metropolitan area names by FIPS or CBSA codes. Looking up
FIPS code is done with the first 2 numbers (state) or 5 numbers (county) and
therefore can be called with longer FIPS codes.
}
\examples{
state_fips_to_name("42")
state_fips_to_name("42003") # same as previous
county_fips_to_name("42003")
county_fips_to_name("42000") # the county "000" returns the state name
cbsa_to_name("38300")

}
\seealso{
\code{\link[=name_to_fips]{name_to_fips()}}, \code{\link[=name_to_cbsa]{name_to_cbsa()}}
}
