% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-coxphMIC.R
\name{print.coxphMIC}
\alias{print.coxphMIC}
\title{The Generic \code{print} Function for Object of \code{coxphMIC} Class}
\usage{
\method{print}{coxphMIC}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{an object of \code{coxphMIC} class.}

\item{digits}{the minimal number of significant digits. See \code{\link[base]{print.default}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The table of estimated regression coefficients beta and the reparameterized gamma.
}
\description{
The Generic \code{print} Function for Object of \code{coxphMIC} Class
}
\details{
The (generic) print method for an \code{coxphMIC} object. The results include info on the estimated gamma and beta.
Depending on the options, significance testing and confidence intervals are also provided.
}
\references{
\itemize{
\item Abdolyousefi, R. N. and Su, X. (2016). \bold{coxphMIC}: An R package for sparse estimation of Cox PH Models via approximated information criterion. Tentatively accepted, \emph{The R Journal}.
\item Su, X. (2015). Variable selection via subtle uprooting.
\emph{Journal of Computational and Graphical Statistics}, \bold{24}(4): 1092--1113.
URL \url{http://www.tandfonline.com/doi/pdf/10.1080/10618600.2014.955176}
\item Su, X., Wijayasinghe, C. S., Fan, J., and Zhang, Y. (2015). Sparse estimation of Cox proportional
hazards models via approximated information criteria. \emph{Biometrics}, \bold{72}(3): 751--759.
URL \url{http://onlinelibrary.wiley.com/doi/10.1111/biom.12484/epdf}
}
}
\seealso{
\code{\link[coxphMIC]{coxphMIC}}
}
