% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg.R
\name{PELT}
\alias{PELT}
\title{Most recent changepoints from AGG method.}
\usage{
PELT(data, pen)
}
\arguments{
\item{data}{a censored data matrix. And then we add this data matrix column wise and resulting
data use as first argument in PELT function.}

\item{pen}{(penalty term)  default 200*log(dim(data)[2]. Here dim(data)[2] means
length of series (n).}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints from AGG method (detect
 changepoint in univariate time series). We use PELT
 for segmenting a time series into changing means, assuming normally
 distributed observations with changing mean but constant variance.
}
\examples{
#example
library(cpcens)
data("censoredex")
data=censoredex
n=144
N=100
agg = apply( data , 2 , sum )
pagg = PELT( agg , 200*log(dim(data)[2]) )
agg.chpts = rep( rev( pagg$cpts )[1] , N )
}
