% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.r
\name{read_bigbed}
\alias{read_bigbed}
\title{Read data from bigBed files.}
\usage{
read_bigbed(bbfile, chrom = NULL, start = NULL, end = NULL, convert = TRUE)
}
\arguments{
\item{bbfile}{filename for bigBed file}

\item{chrom}{read data for specific chromosome}

\item{start}{start position for data}

\item{end}{end position for data}

\item{convert}{convert bigBed values to individual columns}
}
\value{
\code{tibble}
}
\description{
Read data from bigBed files.
}
\examples{
bb <- system.file("extdata", "test.bb", package = "cpp11bigwig")

read_bigbed(bb)

read_bigbed(bb, chrom = "chr10")

}
\seealso{
\url{https://github.com/dpryan79/libBigWig}

\url{https://github.com/brentp/bw-python}
}
