% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_df.R
\name{to_df}
\alias{to_df}
\title{Convert cppRouting graph to data.frame}
\usage{
to_df(Graph)
}
\arguments{
\item{Graph}{An object generated by cppRouting::makegraph() or cpp_simplify() function.}
}
\value{
Data.frame with from, to and dist column
}
\description{
Convert cppRouting graph to data.frame
}
\examples{
#Simple directed graph

edges<-data.frame(from=c(1,2,3,4,5,6,7,8),
to=c(0,1,2,3,6,7,8,5),
dist=c(1,1,1,1,1,1,1,1))

#Construct cppRouting graph
graph<-makegraph(edges,directed=TRUE)

#Convert cppRouting graph to data.frame

df<-to_df(graph)
}
